<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Bulk Messaging and Broadcast
 * Bulk Sending is a public Twilio REST API for 1:Many Message creation up to 100 recipients. Broadcast is a public Twilio REST API for 1:Many Message creation up to 10,000 recipients via file upload.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\PreviewMessaging\V1;

use Twilio\Values;
abstract class MessageModels
{
    /**
     * @property string $to The destination phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format for SMS/MMS or [Channel user address](https://www.twilio.com/docs/sms/channels#channel-addresses) for other 3rd-party channels.
     * @property string $body The text of the message you want to send. Can be up to 1,600 characters in length. Overrides the request-level body and content template if provided.
     * @property array<string,string> $contentVariables Key-value pairs of variable names to substitution values. Refer to the [Twilio Content API Resources](https://www.twilio.com/docs/content-api/content-api-resources#send-a-message-with-preconfigured-content) for more details.
    */
    public static function createMessagingV1Message(array $payload = []): MessagingV1Message
    {
        return new MessagingV1Message($payload);
    }

    /**
     * @property MessagingV1Message[] $messages
     * @property string $from A Twilio phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, an [alphanumeric sender ID](https://www.twilio.com/docs/sms/send-messages#use-an-alphanumeric-sender-id), or a [Channel Endpoint address](https://www.twilio.com/docs/sms/channels#channel-addresses) that is enabled for the type of message you want to send. Phone numbers or [short codes](https://www.twilio.com/docs/sms/api/short-code) purchased from Twilio also work here. You cannot, for example, spoof messages from a private cell phone number. If you are using `messaging_service_sid`, this parameter must be empty.
     * @property string $messagingServiceSid The SID of the [Messaging Service](https://www.twilio.com/docs/sms/services#send-a-message-with-copilot) you want to associate with the Message. Set this parameter to use the [Messaging Service Settings and Copilot Features](https://www.twilio.com/console/sms/services) you have configured and leave the `from` parameter empty. When only this parameter is set, Twilio will use your enabled Copilot Features to select the `from` phone number for delivery.
     * @property string $body The text of the message you want to send. Can be up to 1,600 characters in length.
     * @property string $contentSid The SID of the preconfigured [Content Template](https://www.twilio.com/docs/content-api/create-and-send-your-first-content-api-template#create-a-template) you want to associate with the Message. Must be used in conjuction with a preconfigured [Messaging Service Settings and Copilot Features](https://www.twilio.com/console/sms/services) When this parameter is set, Twilio will use your configured content template and the provided `ContentVariables`. This Twilio product is currently in Private Beta.
     * @property string[] $mediaUrl The URL of the media to send with the message. The media can be of type `gif`, `png`, and `jpeg` and will be formatted correctly on the recipient's device. The media size limit is 5MB for supported file types (JPEG, PNG, GIF) and 500KB for [other types](https://www.twilio.com/docs/sms/accepted-mime-types) of accepted media. To send more than one image in the message body, provide multiple `media_url` parameters in the POST request. You can include up to 10 `media_url` parameters per message. You can send images in an SMS message in only the US and Canada.
     * @property string $statusCallback The URL we should call using the \"status_callback_method\" to send status information to your application. If specified, we POST these message status changes to the URL - queued, failed, sent, delivered, or undelivered. Twilio will POST its [standard request parameters](https://www.twilio.com/docs/messaging/twiml#request-parameters) as well as some additional parameters including \"MessageSid\", \"MessageStatus\", and \"ErrorCode\". If you include this parameter with the \"messaging_service_sid\", we use this URL instead of the Status Callback URL of the [Messaging Service](https://www.twilio.com/docs/messaging/services/api). URLs must contain a valid hostname and underscores are not allowed.
     * @property int $validityPeriod How long in seconds the message can remain in our outgoing message queue. After this period elapses, the message fails and we call your status callback. Can be between 1 and the default value of 14,400 seconds. After a message has been accepted by a carrier, however, we cannot guarantee that the message will not be queued after this period. We recommend that this value be at least 5 seconds.
     * @property string $sendAt The time at which Twilio will send the message. This parameter can be used to schedule a message to be sent at a particular time. Must be in ISO 8601 format.
     * @property string $scheduleType This parameter indicates your intent to schedule a message. Pass the value `fixed` to schedule a message at a fixed time. This parameter works in conjuction with the `SendAt` parameter.
     * @property bool $shortenUrls Determines the usage of Click Tracking. Setting it to `true` will instruct Twilio to replace all links in the Message with a shortened version based on the associated Domain Sid and track clicks on them. If this parameter is not set on an API call, we will use the value set on the Messaging Service. If this parameter is not set and the value is not configured on the Messaging Service used this will default to `false`.
     * @property bool $sendAsMms If set to True, Twilio will deliver the message as a single MMS message, regardless of the presence of media.
     * @property string $maxPrice The maximum total price in US dollars that you will pay for the message to be delivered. Can be a decimal value that has up to 4 decimal places. All messages are queued for delivery and the message cost is checked before the message is sent. If the cost exceeds max_price, the message will fail and a status of Failed is sent to the status callback. If MaxPrice is not set, the message cost is not checked.
     * @property int $attempt Total number of attempts made ( including this ) to send out the message regardless of the provider used
     * @property bool $smartEncoded This parameter indicates whether to detect Unicode characters that have a similar GSM-7 character and replace them. Can be true or false.
     * @property bool $forceDelivery This parameter allows Twilio to send SMS traffic to carriers without checking/caring whether the destination number is a mobile or a landline.
     * @property string $applicationSid The SID of the application that should receive message status. We POST a message_sid parameter and a message_status parameter with a value of sent or failed to the application's message_status_callback. If a status_callback parameter is also passed, it will be ignored and the application's message_status_callback parameter will be used.
    */
    public static function createCreateMessagesRequest(array $payload = []): CreateMessagesRequest
    {
        return new CreateMessagesRequest($payload);
    }

}

class MessagingV1Message implements \JsonSerializable
{
    /**
     * @property string $to The destination phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format for SMS/MMS or [Channel user address](https://www.twilio.com/docs/sms/channels#channel-addresses) for other 3rd-party channels.
     * @property string $body The text of the message you want to send. Can be up to 1,600 characters in length. Overrides the request-level body and content template if provided.
     * @property array<string,string> $contentVariables Key-value pairs of variable names to substitution values. Refer to the [Twilio Content API Resources](https://www.twilio.com/docs/content-api/content-api-resources#send-a-message-with-preconfigured-content) for more details.
    */
        protected $to;
        protected $body;
        protected $contentVariables;
    public function __construct(array $payload = []) {
        $this->to = Values::array_get($payload, 'to');
        $this->body = Values::array_get($payload, 'body');
        $this->contentVariables = Values::array_get($payload, 'contentVariables');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        return [
            'to' => $this->to,
            'body' => $this->body,
            'contentVariables' => $this->contentVariables
        ];
    }
}

class CreateMessagesRequest implements \JsonSerializable
{
    /**
     * @property MessagingV1Message[] $messages
     * @property string $from A Twilio phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, an [alphanumeric sender ID](https://www.twilio.com/docs/sms/send-messages#use-an-alphanumeric-sender-id), or a [Channel Endpoint address](https://www.twilio.com/docs/sms/channels#channel-addresses) that is enabled for the type of message you want to send. Phone numbers or [short codes](https://www.twilio.com/docs/sms/api/short-code) purchased from Twilio also work here. You cannot, for example, spoof messages from a private cell phone number. If you are using `messaging_service_sid`, this parameter must be empty.
     * @property string $messagingServiceSid The SID of the [Messaging Service](https://www.twilio.com/docs/sms/services#send-a-message-with-copilot) you want to associate with the Message. Set this parameter to use the [Messaging Service Settings and Copilot Features](https://www.twilio.com/console/sms/services) you have configured and leave the `from` parameter empty. When only this parameter is set, Twilio will use your enabled Copilot Features to select the `from` phone number for delivery.
     * @property string $body The text of the message you want to send. Can be up to 1,600 characters in length.
     * @property string $contentSid The SID of the preconfigured [Content Template](https://www.twilio.com/docs/content-api/create-and-send-your-first-content-api-template#create-a-template) you want to associate with the Message. Must be used in conjuction with a preconfigured [Messaging Service Settings and Copilot Features](https://www.twilio.com/console/sms/services) When this parameter is set, Twilio will use your configured content template and the provided `ContentVariables`. This Twilio product is currently in Private Beta.
     * @property string[] $mediaUrl The URL of the media to send with the message. The media can be of type `gif`, `png`, and `jpeg` and will be formatted correctly on the recipient's device. The media size limit is 5MB for supported file types (JPEG, PNG, GIF) and 500KB for [other types](https://www.twilio.com/docs/sms/accepted-mime-types) of accepted media. To send more than one image in the message body, provide multiple `media_url` parameters in the POST request. You can include up to 10 `media_url` parameters per message. You can send images in an SMS message in only the US and Canada.
     * @property string $statusCallback The URL we should call using the \"status_callback_method\" to send status information to your application. If specified, we POST these message status changes to the URL - queued, failed, sent, delivered, or undelivered. Twilio will POST its [standard request parameters](https://www.twilio.com/docs/messaging/twiml#request-parameters) as well as some additional parameters including \"MessageSid\", \"MessageStatus\", and \"ErrorCode\". If you include this parameter with the \"messaging_service_sid\", we use this URL instead of the Status Callback URL of the [Messaging Service](https://www.twilio.com/docs/messaging/services/api). URLs must contain a valid hostname and underscores are not allowed.
     * @property int $validityPeriod How long in seconds the message can remain in our outgoing message queue. After this period elapses, the message fails and we call your status callback. Can be between 1 and the default value of 14,400 seconds. After a message has been accepted by a carrier, however, we cannot guarantee that the message will not be queued after this period. We recommend that this value be at least 5 seconds.
     * @property string $sendAt The time at which Twilio will send the message. This parameter can be used to schedule a message to be sent at a particular time. Must be in ISO 8601 format.
     * @property string $scheduleType This parameter indicates your intent to schedule a message. Pass the value `fixed` to schedule a message at a fixed time. This parameter works in conjuction with the `SendAt` parameter.
     * @property bool $shortenUrls Determines the usage of Click Tracking. Setting it to `true` will instruct Twilio to replace all links in the Message with a shortened version based on the associated Domain Sid and track clicks on them. If this parameter is not set on an API call, we will use the value set on the Messaging Service. If this parameter is not set and the value is not configured on the Messaging Service used this will default to `false`.
     * @property bool $sendAsMms If set to True, Twilio will deliver the message as a single MMS message, regardless of the presence of media.
     * @property string $maxPrice The maximum total price in US dollars that you will pay for the message to be delivered. Can be a decimal value that has up to 4 decimal places. All messages are queued for delivery and the message cost is checked before the message is sent. If the cost exceeds max_price, the message will fail and a status of Failed is sent to the status callback. If MaxPrice is not set, the message cost is not checked.
     * @property int $attempt Total number of attempts made ( including this ) to send out the message regardless of the provider used
     * @property bool $smartEncoded This parameter indicates whether to detect Unicode characters that have a similar GSM-7 character and replace them. Can be true or false.
     * @property bool $forceDelivery This parameter allows Twilio to send SMS traffic to carriers without checking/caring whether the destination number is a mobile or a landline.
     * @property string $applicationSid The SID of the application that should receive message status. We POST a message_sid parameter and a message_status parameter with a value of sent or failed to the application's message_status_callback. If a status_callback parameter is also passed, it will be ignored and the application's message_status_callback parameter will be used.
    */
        protected $messages;
        protected $from;
        protected $messagingServiceSid;
        protected $body;
        protected $contentSid;
        protected $mediaUrl;
        protected $statusCallback;
        protected $validityPeriod;
        protected $sendAt;
        protected $scheduleType;
        protected $shortenUrls;
        protected $sendAsMms;
        protected $maxPrice;
        protected $attempt;
        protected $smartEncoded;
        protected $forceDelivery;
        protected $applicationSid;
    public function __construct(array $payload = []) {
        $this->messages = Values::array_get($payload, 'messages');
        $this->from = Values::array_get($payload, 'from');
        $this->messagingServiceSid = Values::array_get($payload, 'messagingServiceSid');
        $this->body = Values::array_get($payload, 'body');
        $this->contentSid = Values::array_get($payload, 'contentSid');
        $this->mediaUrl = Values::array_get($payload, 'mediaUrl');
        $this->statusCallback = Values::array_get($payload, 'statusCallback');
        $this->validityPeriod = Values::array_get($payload, 'validityPeriod');
        $this->sendAt = Values::array_get($payload, 'sendAt');
        $this->scheduleType = Values::array_get($payload, 'scheduleType');
        $this->shortenUrls = Values::array_get($payload, 'shortenUrls');
        $this->sendAsMms = Values::array_get($payload, 'sendAsMms');
        $this->maxPrice = Values::array_get($payload, 'maxPrice');
        $this->attempt = Values::array_get($payload, 'attempt');
        $this->smartEncoded = Values::array_get($payload, 'smartEncoded');
        $this->forceDelivery = Values::array_get($payload, 'forceDelivery');
        $this->applicationSid = Values::array_get($payload, 'applicationSid');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        return [
            'messages' => $this->messages,
            'from' => $this->from,
            'messagingServiceSid' => $this->messagingServiceSid,
            'body' => $this->body,
            'contentSid' => $this->contentSid,
            'mediaUrl' => $this->mediaUrl,
            'statusCallback' => $this->statusCallback,
            'validityPeriod' => $this->validityPeriod,
            'sendAt' => $this->sendAt,
            'scheduleType' => $this->scheduleType,
            'shortenUrls' => $this->shortenUrls,
            'sendAsMms' => $this->sendAsMms,
            'maxPrice' => $this->maxPrice,
            'attempt' => $this->attempt,
            'smartEncoded' => $this->smartEncoded,
            'forceDelivery' => $this->forceDelivery,
            'applicationSid' => $this->applicationSid
        ];
    }
}

